module net.BurtonRadons.dedit.syntaxHighlighter;

import net.BurtonRadons.dedit.main;
import net.BurtonRadons.dedit.document;
import std.string;

/* The base syntax highlighter class.  This allows forward context
 * highlighting (an example is the handling of the asm statement in
 * the D highlighter) but not backwards (which is crazy anyways),
 * and allows you to pass as much data as you want to the next line.
 */

class SyntaxHighlighter
{
    /** Return indentation for the next line after this line, in case the user hit return
      * after this line.  The default returns zero.
      * @param document The document this relates to.
      * @param index The index of the previous line.
      * @return Return -1 to dedent, 0 to keep the same, or +1 to indent.
      */
    int indent (Document document, int index)
    {
        return 0;
    }

    /* Return the number of extra bytes this highlighter requires for the line end. */
    int extraSize () { return 0; }

    /* Highlight the line.
     *
     * @param line The code line to highlight.
     * @param high The output highlight codes.
     * @param last A pointer to the extra data for the previous line or null if this
     * is the first line.  If the context is identical, the content of the extra data must
     * be identical.  This quality is used to minimise the need for recalculation.
     * @param next A pointer to the extra data for the current line.
     */

    void highlight (char [] line, char [] high, void *last, void *next)
    {
    }

    /* Get the name of the language being highlighted. */
    char [] name () { return null; }

    /* Get the filename wildcards for this type. */
    char [] exts () { return null; }

    /* Get the amount this file matches your type, from 0 (not at all) to 1 (completely). */
    float match (char [] filename, char [] [] data) { return 0; }

    /* List of highlighters that add their singletons to it. */
    static SyntaxHighlighter [] list;

    /* Find the syntax highlighter with this name or null. */
    static SyntaxHighlighter findName (char [] name)
    {
        for (int c; c < list.length; c ++)
            if (list [c].name () == name)
                return list [c];

        return null;
    }

    /* Get the default tab settings for this highlighter or null. */
    TabParams tabParamsDefault ()
    {
        return null;
    }

    /* Get the tab settings or the default. */
    TabParams tabParams ()
    {
        TabParams def;

        for (int c; c < global.tabParams.length; c ++)
        {
            TabParams par = global.tabParams [c];

            if (par.type === null)
                def = par;
            if (!par.useDefault && par.type === this)
                return par;
        }

        def = tabParamsDefault ();
        if (def === null)
        {
            def = new TabParams ();
            global.tabParams ~= def;
        }

        return def;
    }

    /* Sort based on name. */
    int opCmp (Object other)
    {
        if (!cast (SyntaxHighlighter) other)
            return 0;
        return std.string.cmp (name (), (cast (SyntaxHighlighter) other).name ());
    }
}

/* Textual syntax highlighter. */
class Text_Highlighter : SyntaxHighlighter
{
    static this ()
    {
        list ~= new Text_Highlighter ();
    }

    override char [] name () { return "Text File"; }
    override char [] exts () { return "*.txt;readme;license"; }

    override float match (char [] filename, char [] [] data)
    {
        if (std.string.tolower (filename) == "readme" || std.string.tolower (filename) == "license")
            return 1;

        char [] ext = std.string.tolower (std.path.getExt (filename));

        if (ext == "txt")
            return 1;
        return 0;
    }

    override int extraSize () { return 0; }

    override void highlight (char [] line, char [] high, void *lastp, void *nextp)
    {
        high [] = 0;
    }
}

